/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class AlloyerRecipe
extends MekanismRecipe
implements TriPredicate<ItemStack, ItemStack, ItemStack> {
    private final ItemStackIngredient mainInput;
    private final ItemStackIngredient extraInput;
    private final ItemStackIngredient tertiaryExtraInput;
    private final ItemStack output;

    public AlloyerRecipe(ResourceLocation id, ItemStackIngredient mainInput, ItemStackIngredient extraInput, ItemStackIngredient secondaryExtraInput, ItemStack output) {
        super(id);
        this.mainInput = Objects.requireNonNull(mainInput, "Main input cannot be null.");
        this.extraInput = Objects.requireNonNull(extraInput, "Secondary input cannot be null.");
        this.tertiaryExtraInput = Objects.requireNonNull(secondaryExtraInput, "Tertiary input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.m_41619_()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.m_41777_();
    }

    public boolean test(ItemStack input, ItemStack extra, ItemStack secondExtra) {
        return this.mainInput.test((Object)input) && this.extraInput.test((Object)extra) && this.tertiaryExtraInput.test((Object)secondExtra);
    }

    public ItemStackIngredient getMainInput() {
        return this.mainInput;
    }

    public ItemStackIngredient getExtraInput() {
        return this.extraInput;
    }

    public ItemStackIngredient getTertiaryExtraInput() {
        return this.tertiaryExtraInput;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public ItemStack getOutput(@NotNull ItemStack input, @NotNull ItemStack extra, @NotNull ItemStack secondExtra) {
        return this.output.m_41777_();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public List<ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    public boolean m_142505_() {
        return this.mainInput.hasNoMatchingInstances() || this.extraInput.hasNoMatchingInstances() || this.tertiaryExtraInput.hasNoMatchingInstances();
    }

    public void write(FriendlyByteBuf buffer) {
        this.mainInput.write(buffer);
        this.extraInput.write(buffer);
        this.tertiaryExtraInput.write(buffer);
        buffer.m_130055_(this.output);
    }
}

